document.addEventListener("DOMContentLoaded", () => {

&nbsp; const blocHTML = document.querySelector(".bloccode1");

&nbsp; const blocCSS = document.querySelector(".bloccode2");

&nbsp; const blocJS = document.querySelector(".bloccode3");

&nbsp; const blocAutre = document.querySelector(".bloccode4");



&nbsp; // Fonction pour charger un fichier et l'afficher en texte brut

&nbsp; function chargerCodeBrut(chemin, element) {

&nbsp;   fetch(chemin)

&nbsp;     .then(res => {

&nbsp;       if (!res.ok) throw new Error("Erreur de chargement : " + chemin);

&nbsp;       return res.text();

&nbsp;     })

&nbsp;     .then(txt => {

&nbsp;       element.textContent = txt; // texte brut pour afficher le code HTML

&nbsp;     })

&nbsp;     .catch(err => {

&nbsp;       element.textContent = "⚠️ Impossible de charger " + chemin;

&nbsp;       console.error(err);

&nbsp;     });

&nbsp; }



&nbsp; // Fonction pour charger un fichier Markdown interprété

&nbsp; function chargerMarkdown(chemin, element) {

&nbsp;   fetch(chemin)

&nbsp;     .then(res => {

&nbsp;       if (!res.ok) throw new Error("Erreur de chargement : " + chemin);

&nbsp;       return res.text();

&nbsp;     })

&nbsp;     .then(txt => {

&nbsp;       element.innerHTML = marked.parse(txt); // Markdown → HTML

&nbsp;     })

&nbsp;     .catch(err => {

&nbsp;       element.textContent = "⚠️ Impossible de charger " + chemin;

&nbsp;       console.error(err);

&nbsp;     });

&nbsp; }



&nbsp; // Chargement des fichiers

&nbsp; chargerCodeBrut("texteexterne/html.md", blocHTML);

&nbsp; chargerMarkdown("texteexterne/css.md", blocCSS);

&nbsp; chargerMarkdown("texteexterne/js.md", blocJS);

&nbsp; chargerMarkdown("texteexterne/autrecode.md", blocAutre);

});



