body {

&nbsp;   background: url(images/fondusite01.jpg) no-repeat fixed; /\* image de fond fixe, non répétée \*/

&nbsp;   background-color: #fcfbfb; /\* Définit la couleur de fond principale \*/

&nbsp;   background-size: cover; /\* L’image couvre tout l’écran sans déformation \*/

&nbsp;   font-family: "Lora", serif; /\* Définit la police principale du site \*/

&nbsp;   text-align: center; /\* Centre le texte par défaut \*/

&nbsp;   color: #070707; /\* Couleur de texte principale \*/

&nbsp;   margin: 0; /\* Supprime les marges par défaut du navigateur \*/

&nbsp;   padding: 0; /\* Supprime tous les espacements internes par défaut du navigateur \*/

&nbsp;   width: 100%; height: 100%;

}

\* {

&nbsp;   box-sizing: border-box; /\* Inclut bordure et padding dans le calcul de la taille \*/

&nbsp;   margin: 0; /\* Supprime toutes les marges par défaut \*/

&nbsp;   padding: 0; /\* Supprime tous les espacements internes par défaut \*/

}

/\* ─────── STRUCTURE DE PAGE CENTRE ET TRANSPARENT ─────── \*/

.barrenav1structure {  /\* structure 100% Centré \*/

&nbsp;   margin: 5px; /\* Espace externe autour du bloc titre \*/

&nbsp;   padding: 15px; /\* Espace interne autour du contenu \*/

&nbsp;   display: flex; /\* Active Flexbox pour centrer le titre \*/

&nbsp;   justify-content: center; /\* Centre horizontalement le contenu \*/

&nbsp;   align-items: center; /\* Centre verticalement le contenu \*/

&nbsp;   width: 100%; /\* Prend toute la largeur disponible \*/

&nbsp;   text-align: center; /\* Centre le texte du titre \*/

}

.barrenav1 {  /\* Fond transparent - Flex \*/

&nbsp;   display: inline-flex; /\* Crée un conteneur flex en ligne \*/

&nbsp;   flex-wrap: wrap; /\* Permet le retour à la ligne du contenu \*/

&nbsp;   justify-content: center; /\* Centre horizontalement \*/

&nbsp;   align-items: center; /\* Centre verticalement le contenu \*/

&nbsp;   gap: clamp(10px, 1vw, 30px); /\* Espacement adaptable entre les éléments \*/

&nbsp;   padding: 0.3em 0.6em; /\* Espacement interne léger \*/

&nbsp;   font-weight: 500; /\* Texte en gras \*/

&nbsp;   width: fit-content; /\* Largeur auto selon le contenu \*/

&nbsp;   height: fit-content; /\* Hauteur auto selon le contenu \*/

&nbsp;   line-height: 1; /\* Hauteur de ligne compacte \*/

}

.barrenav1logo {  /\* Taille du logo proportionnelle au texte \*/

&nbsp;   height: 1em; /\* Taille du logo proportionnelle au texte \*/

&nbsp;   width: auto; /\* Garde les proportions originales \*/

&nbsp;   display: block; /\* Permet un centrage plus précis \*/

}

.barrenav1 a { /\* Taille de texte responsive \*/

&nbsp;   color: #e0f806; 

&nbsp;   font-size: clamp(16px, 5vw, 40px); /\* Taille de texte responsive \*/

&nbsp;   text-decoration: none; /\* Supprime le soulignement \*/

&nbsp;   line-height: 1; /\* Réduit l’espace vertical \*/

}

/\* ──  TITRE de la page centré  ──── \*/

.pagetitrestructure {  /\* structure 100% Centré \*/

&nbsp;   display: flex; /\* Active Flexbox pour les boutons \*/

&nbsp;   justify-content: center; /\* Centre les boutons horizontalement \*/

&nbsp;   flex-wrap: wrap; /\* Autorise le retour à la ligne \*/

&nbsp;   padding: 0.5rem 0; /\* Espace vertical autour du groupe \*/

}

.pagetitre {  /\* Fond Blanc - Largeur auto selon le contenu - Flex \*/

&nbsp;   background: rgba(7, 7, 7, 0.5); /\* Fond blanc semi-transparent \*/

&nbsp;	margin: 5px 5px 5px 5px;

&nbsp;   padding: 0.3em 0.6em; /\* Espacement interne léger \*/

&nbsp;   width: fit-content; /\* Largeur auto selon le contenu \*/

&nbsp;   max-width: fit-content; /\* Largeur auto selon le contenu \*/

&nbsp;   height: 80%; /\* Hauteur auto selon le contenu \*/

&nbsp;   line-height: 1; /\* Hauteur de ligne compacte \*/

&nbsp;   color: #e0f806; 

&nbsp;   box-shadow: 10px 5px 25px rgba(0, 0, 0, 0.8);

&nbsp;	border-radius: 10px;

}

/\* ──  bloc titre + article  ──── \*/

.blocarticle1 {  /\* Fond Blanc - Contenu a Gauche - Flex \*/

&nbsp;   margin: 20px auto;          /\* ✅ centre la section horizontalement \*/

&nbsp;   padding: 2px;

&nbsp;   width: 80%;                 /\* ✅ même largeur que tes autres blocs \*/

&nbsp;   display: flex;

&nbsp;   flex-direction: column;

&nbsp;   align-items: flex-start;    /\* garde le contenu aligné à gauche \*/

&nbsp;   text-align: left;

}

.blocarticle1titre { /\* Réglage du texte \*/

&nbsp;   background: rgba(255, 255, 255, 0.9);

&nbsp;   margin: 10px;

&nbsp;   padding: 1em;

&nbsp;   width: fit-content; /\* La largeur s'ajuste au texte \*/

&nbsp;   box-sizing: border-box;

&nbsp;   line-height: 1;

&nbsp;   font-weight: bold;

&nbsp;   display: inline-block; /\* ✅ rend le fond ajusté au contenu \*/

&nbsp;   justify-content: flex-start;

&nbsp;   align-items: flex-start;

&nbsp;   box-shadow: 10px 5px 25px rgba(0, 0, 0, 0.3);

&nbsp;   border-radius: 10px;

&nbsp;   overflow-wrap: break-word;

&nbsp;   word-wrap: break-word;

&nbsp;   word-break: break-word;

}

.blocarticle1texte { /\* Réglage du texte \*/

&nbsp;   background: rgba(255, 255, 255, 0.9);

&nbsp;   margin: 5px;

&nbsp;   margin-bottom: 20px;   /\* Espacement entre chaque article \*/

&nbsp;   padding: 1em;

&nbsp;   width: 100%;           /\* Remplit toute la largeur de son parent \*/

&nbsp;   box-sizing: border-box; /\* prend en compte le padding dans la largeur \*/

&nbsp;   line-height: 1.4;

&nbsp;   font-weight: bold;

&nbsp;   display: flex;

&nbsp;   flex-direction: column;

&nbsp;   justify-content: flex-start;

&nbsp;   align-items: flex-start; /\* Aligne le texte et les éléments à gauche \*/

&nbsp;   box-shadow: 10px 5px 25px rgba(0, 0, 0, 0.3);

&nbsp;   border-radius: 10px;

&nbsp;   /\* Empêche le texte de dépasser \*/

&nbsp;   overflow-wrap: break-word; /\* coupe les mots trop longs \*/

&nbsp;   word-wrap: break-word; /\* compatibilité ancienne \*/

&nbsp;   word-break: break-word;

}

/\* ─────── BOUTONS ─────── \*/

.bouton1 { /\* Réglage du bouton \*/

&nbsp;   padding: 6px 16px; /\* Espace interne \*/

&nbsp;   background: rgba(250, 246, 1, 0.9); /\* Fond blanc semi-transparent \*/

&nbsp;   border-radius: 10px; /\* Coins arrondis \*/

&nbsp;   font-weight: 600; /\* Texte semi-gras \*/

&nbsp;   color: #000; /\* Texte noir \*/

&nbsp;   text-align: center; /\* Centre le texte \*/

&nbsp;   cursor: pointer; /\* Curseur main au survol \*/

&nbsp;   transition: all 0.25s ease-in-out; /\* Animation douce au survol \*/

}

.bouton1 a { /\* Réglage du texte du bouton \*/

&nbsp;   font-size: 1rem; /\* Taille de texte normale \*/

&nbsp;   text-decoration: none; /\* Supprime le soulignement \*/

&nbsp;   color: inherit; /\* Hérite de la couleur du parent \*/

&nbsp;   display: inline-block; /\* Rendre le lien entièrement cliquable \*/

}

.bouton1:hover { /\* Réglage du survol de la souris \*/

&nbsp;   background-color: #f8faf5; /\* Change de couleur au survol \*/

&nbsp;   transform: scale(1.05); /\* Zoom léger \*/

&nbsp;   box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2); /\* Ajoute une ombre douce \*/

}



/\* ──  bloc Code pour afficher du code html/css/js via des fichier externe  ──── \*/

.bloccodestructure {

&nbsp;   display: flex;

&nbsp;   justify-content: center;

&nbsp;   gap: 20px;

&nbsp;   flex-wrap: wrap;

&nbsp;   padding: 0.5rem 0;

}

.bloccode1, .bloccode2, .bloccode3, .bloccode4 {

&nbsp;   background: #f6f8fa;

&nbsp;   color: #24292f;

&nbsp;   box-shadow: 5px 5px 15px rgba(0,0,0,0.15);

&nbsp;   border-radius: 10px;

&nbsp;   width: 45%;

&nbsp;   padding: 15px 20px;

&nbsp;   display: flex;

&nbsp;   flex-direction: column;

&nbsp;   align-items: flex-start;

&nbsp;   text-align: left;

&nbsp;   font-family: "Fira Code", "Consolas", "Courier New", monospace;

&nbsp;   box-sizing: border-box;

&nbsp;   line-height: 1.25;

&nbsp;   font-weight: normal;

&nbsp;   overflow-wrap: break-word;

&nbsp;   margin-bottom: 20px;

&nbsp;   white-space: pre-wrap; /\* important pour .bloccode1 \*/

}

/\* Paragraphes dans Markdown \*/

.bloccode2 p, .bloccode3 p, .bloccode4 p {

&nbsp;   margin: 0.3em 0;

}



/\* Titres Markdown \*/

.bloccode2 h1, .bloccode3 h1, .bloccode4 h1 {

&nbsp;   font-size: 1.4rem;

&nbsp;   font-weight: bold;

&nbsp;   margin: 0.5em 0 0.3em 0;

&nbsp;   color: #0366d6;

}

.bloccode2 h2, .bloccode3 h2, .bloccode4 h2 {

&nbsp;   font-size: 1.2rem;

&nbsp;   font-weight: bold;

&nbsp;   margin: 0.4em 0 0.2em 0;

&nbsp;   color: #005cc5;

}



/\* Listes Markdown \*/

.bloccode2 ul, .bloccode3 ul, .bloccode4 ul {

&nbsp;   margin: 0.3em 0 0.3em 1.2em;

&nbsp;   padding: 0;

}



/\* Liens Markdown \*/

.bloccode2 a, .bloccode3 a, .bloccode4 a {

&nbsp;   color: #0366d6;

&nbsp;   text-decoration: underline;

}



/\* Code inline dans Markdown \*/

.bloccode2 code, .bloccode3 code, .bloccode4 code {

&nbsp;   background: rgba(27,31,35,0.05);

&nbsp;   padding: 2px 5px;

&nbsp;   border-radius: 5px;

&nbsp;   font-family: "Fira Code", monospace;

}



/\* Blocs de code Markdown \*/

.bloccode2 pre, .bloccode3 pre, .bloccode4 pre {

&nbsp;   background: #f0f0f0;

&nbsp;   padding: 10px;

&nbsp;   border-radius: 8px;

&nbsp;   overflow-x: auto;

&nbsp;   margin: 0.5em 0;

}



/\* Responsive \*/

@media (max-width: 768px) {

&nbsp;   .bloccode1, .bloccode2, .bloccode3, .bloccode4 {

&nbsp;       width: 90%;

&nbsp;   }

}



