/* ════════════════════════════════════════════════════════════════════
   SCRIPT PRINCIPAL
   Fonctions :
   1. Apparition/disparition de la barre de navigation selon le scroll
   2. Changement d’image au survol
   3. Bouton retour en haut de page
═══════════════════════════════════════════════════════════════════════ */

(function () {
    const navbar = document.getElementById('navbar');
    const main = document.querySelector('main');
    if (!navbar) return;
  
    /* Variables scroll */
    let lastScroll = window.scrollY || 0;
    let ticking = false;
    const hideThreshold = 10;
    const minScrollToHide = 50;
    const paddingCorrection = 5;
  
    /* ---------- Ajuste automatiquement le padding-top du main ---------- */
    function updateMainOffset() {
        const navHeight = Math.ceil(navbar.getBoundingClientRect().height);
        main.style.paddingTop = (navHeight - paddingCorrection) + 'px';
    }
  
    /* ---------- Gestion du scroll ---------- */
    function onScroll() {
        const currentScroll = window.scrollY || 0;
  
        if (currentScroll <= 0) {
            navbar.classList.add('visible');
            lastScroll = currentScroll;
            return;
        }
  
        const delta = currentScroll - lastScroll;
  
        if (Math.abs(delta) < hideThreshold) {
            lastScroll = currentScroll;
            return;
        }
  
        if (delta > 0 && currentScroll > minScrollToHide) {
            navbar.classList.remove('visible');
        } else if (delta < 0) {
            navbar.classList.add('visible');
        }
  
        lastScroll = currentScroll;
    }
  
    function requestTick() {
        if (!ticking) {
            window.requestAnimationFrame(() => {
                onScroll();
                ticking = false;
            });
            ticking = true;
        }
    }
  
    /* ---------- Initialisation ---------- */
    window.addEventListener('load', () => {
        navbar.classList.add('visible');
        updateMainOffset();
        lastScroll = window.scrollY || 0;
    });
  
    window.addEventListener('resize', updateMainOffset);
    window.addEventListener('scroll', requestTick, { passive: true });
  
    /* ---------- Changement d’image au survol ---------- */
    document.querySelectorAll('.change-on-hover').forEach(img => {
        const originalSrc = img.getAttribute('src');
        const hoverSrc = img.getAttribute('data-hover');
        if (!hoverSrc) return;
  
        img.addEventListener('mouseenter', () => img.src = hoverSrc);
        img.addEventListener('mouseleave', () => img.src = originalSrc);
        img.addEventListener('focus', () => img.src = hoverSrc);
        img.addEventListener('blur', () => img.src = originalSrc);
    });
  
    /* ════════════════════════════════════════════════════════════════
       BOUTON RETOUR EN HAUT DE PAGE
       (scroll fluide + reste en haut sans bug)
    ════════════════════════════════════════════════════════════════ */
    const scrollTopBtn = document.getElementById('scroll-top-btn');
    if (scrollTopBtn) {
        scrollTopBtn.addEventListener('click', () => {
            window.scrollTo({
                top: 0,
                behavior: "smooth"
            });
        });
    }
  
  })();
  